;; This example shows the firmware functions used to load
;; a file with a AMSDOS header (a non-ASCII file)
;;
;; in this example, the file is called SCREEN.SCR
;; and is loaded to the default screen location &c000-&ffff

;; firmware function to open a file for reading
.cas_in_open equ &bc77
;; firmware function to read an entire file (must have a AMSDOS header)
;; the file must have been opened for reading
.cas_in_direct equ &bc83
;; firmware function to close a file opened for reading
.cas_in_close equ &bc7a

org &4000

call load_file
ret


.load_file
;; B = length of the filename in characters
ld b,end_filename-filename

;; HL = address of the start of the filename
ld hl,filename

;; DE = address of a 2k buffer
;; 
;; in disc mode: this buffer is not used when CAS IN DIRECT
;; firmware function is used, so it is safe to put it anywhere
;; you want.
ld de,0

;; firmware function to open a file for reading
call cas_in_open

;; cas_in_open returns:
;; if file was opened successfully:
;; - carry is true 
;; - HL contains address of the file's AMSDOS header
;; - DE contains the load address of the file (from the header)
;; - BC contains the length of the file (from the file header)
;; - A contains the file type (2 for binary files)

;; firmware function to load the entire file
;; this will work with files that have a AMSDOS header (ASCII
;; files do not have a header)

;; HL = load address
ld hl,&c000
;; read file
call cas_in_direct

;; firmware function to close a file opened for reading
call cas_in_close

ret


;; the filename to load
;; disc filenames are a maximum of 12 characters long
;; 8 characters for name, and 3 characters for extension
.filename
defb "SCREEN.SCR"
.end_filename


